﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Collections;
using System.Globalization;
using System.Diagnostics;
using System.Reflection;

namespace SE290A_BackOfficeSim_CoreApi
{
    public class EslImageInfo
    {
        public class COLUMN_ITEM
        {
            public string Key;
            public string Property;

            public COLUMN_ITEM(string key, string property)
            {
                Key = key;
                Property = property;
            }
        }

        public static COLUMN_ITEM[] COLUMNS =
        {
             new COLUMN_ITEM("ID",              "Id"),
             new COLUMN_ITEM("MAC",             "Mac"),
             new COLUMN_ITEM("DESCRIPTION",     "Description"),
			 new COLUMN_ITEM("VARIANT",			"Variant"),
             new COLUMN_ITEM("ONLINE",          "Online"),
             new COLUMN_ITEM("EVENT",           "Event"),
             new COLUMN_ITEM("VALUE",           "Value"),
             new COLUMN_ITEM("MESSAGE",         "Message"),
             new COLUMN_ITEM("SEQNR",           "SeqNr"),
        };

        public string Id = null;
        public string Description = "";
        public string Variant = null;
        public int Online = 0;
        public string Event = null;
        public string Value = "";
        public string Message = "";
        public string SeqNr = null;

        private string _MAC;

        public string MAC
        {
            get
            {
                return _MAC;
            }
            set
            {
                if (value == null)
                    return;

                _MAC = value;
            }
        }

        public EslImageInfo(string MAC)
        {
            this.MAC = MAC;
        }

        public EslImageInfo()
        {

        }

        public override string ToString()
        {
            if (!Event.Equals("PRESSED") && !Event.Equals("LONG_PRESSED") && !Event.Equals("DOUBLE_PRESSED") && !Event.Equals("VLONG_PRESSED"))
            {
                if (string.IsNullOrEmpty(Message))
                    return DateTime.Now.ToLocalTime() + " " + this.MAC + " " + this.Online + " " + this.Event + " (" + this.Id + ", " + this.Description + ")";
                else
                    return DateTime.Now.ToLocalTime() + " " + this.MAC + " " + this.Online + " " + this.Event + " (" + this.Id + ", " + this.Description + ", " + this.Message + ")";
            }
            else if (string.IsNullOrEmpty(this.Message) || this.Message.Equals("OK"))
                return DateTime.Now.ToLocalTime() + " " + this.MAC + " " + this.Online + " " + this.Event + " (" + this.Id + ", " + this.Description + ", " + this.Value + ")";
            else
                return DateTime.Now.ToLocalTime() + " " + this.MAC + " " + this.Online + " " + this.Event + " (" + this.Id + ", " + this.Description + ", " + this.Value + ") " + this.Message;
        }

    }

    public static class ReflectionHelper
    {
        public static object GetPropertyValue(object obj, string propertyName)
        {
            FieldInfo fInfo;
            PropertyInfo pInfo;

            fInfo = typeof(EslImageInfo).GetField(propertyName);

            if (fInfo != null)
                return fInfo.GetValue(obj);

            pInfo = typeof(EslImageInfo).GetProperty(propertyName);
            if (pInfo != null)
                return pInfo.GetValue(obj, null);

            return null;
        }
    }
}